--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNGRailParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCobjMod
  local LOCspinStartValue
  local LOCrosPath
  local LOCundoState       = on
  local LOCrosStyle        = ""
  local LOCresourceKitMode = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNchangeGrailUItab FUNtab =
  (
    local LOCoffset1, LOCoffset2, LOCoffset3, LOCoffset4
    LOCoffset1 = LOCoffset2 = LOCoffset3 = LOCoffset4 = 0
    if FUNtab == 1 then (LOCoffset1 = 0; LOCoffset2 = LOCoffset3 = LOCoffset4 = -2000; DYNgrailParams.LBtabDescription.text = DYNuiResourcesGroups[3])
    if FUNtab == 2 then (LOCoffset2 = 0; LOCoffset1 = LOCoffset3 = LOCoffset4 = -2000; DYNgrailParams.LBtabDescription.text = DYNuiResourcesGroups[123])
    if FUNtab == 3 then (LOCoffset3 = 0; LOCoffset1 = LOCoffset2 = LOCoffset4 = -2000; DYNgrailParams.LBtabDescription.text = DYNuiResourcesGroups[124])
    if FUNtab == 4 then (LOCoffset4 = 0; LOCoffset1 = LOCoffset2 = LOCoffset3 = -2000; DYNgrailParams.LBtabDescription.text = DYNuiResourcesGroups[125])

    --- General Params
    DYNgrailParams.GBDYNparent.pos.x       = LOCoffset1 + 13
    DYNgrailParams.PKDYNparent.pos.x       = LOCoffset1 + 18
    DYNgrailParams.LBDYNgWidthL.pos.x      = LOCoffset1 + 13
    DYNgrailParams.SPDYNgWidthL.pos.x      = LOCoffset1 + (DYNiniExplorerWidth - 55)
    DYNgrailParams.CBDYNlock.pos.x         = LOCoffset1 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNgWidthR.pos.x      = LOCoffset1 + 13
    DYNgrailParams.SPDYNgWidthR.pos.x      = LOCoffset1 + (DYNiniExplorerWidth - 55)
    DYNgrailParams.LBDYNgHeight.pos.x      = LOCoffset1 + 13
    DYNgrailParams.SPDYNgHeight.pos.x      = LOCoffset1 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNgOffsetX.pos.x     = LOCoffset1 + 13
    DYNgrailParams.SPDYNgOffsetX.pos.x     = LOCoffset1 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNgOffsetZ.pos.x     = LOCoffset1 + 13
    DYNgrailParams.SPDYNgOffsetZ.pos.x     = LOCoffset1 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.BUDYNmirror.pos.x       = LOCoffset1 + 13

    --- Post Params
    DYNgrailParams.CKDYNposton.pos.x       = LOCoffset2 + 13
    DYNgrailParams.LBDYNpostType.pos.x     = LOCoffset2 + 13
    DYNgrailParams.DDDYNpostType.pos.x     = LOCoffset2 + 13
    DYNgrailParams.CBDYNpostFlip.pos.x     = LOCoffset2 + (DYNiniExplorerWidth - 102)
    DYNgrailParams.CBDYNpostCapT.pos.x     = LOCoffset2 + 13
    DYNgrailParams.CBDYNpostCapB.pos.x     = LOCoffset2 + (DYNiniExplorerWidth - 102)
    DYNgrailParams.LBDYNpostMat.pos.x      = LOCoffset2 + 13
    DYNgrailParams.DDDYNpostMat.pos.x      = LOCoffset2 + 13
    DYNgrailParams.LBDYNpostWidth.pos.x    = LOCoffset2 + 13
    DYNgrailParams.SPDYNpostWidth.pos.x    = LOCoffset2 + (DYNiniExplorerWidth - 106)
    DYNgrailParams.SPDYNpostDepth.pos.x    = LOCoffset2 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNspacing.pos.x      = LOCoffset2 + 13
    DYNgrailParams.SPDYNspacing.pos.x      = LOCoffset2 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNgroundDepth.pos.x  = LOCoffset2 + 13
    DYNgrailParams.SPDYNgroundDepth.pos.x  = LOCoffset2 + (DYNiniExplorerWidth - 39)

    --- Brace Params
    DYNgrailParams.CKDYNbraceOn.pos.x      = LOCoffset3 + 13
    DYNgrailParams.LBDYNbraceType.pos.x    = LOCoffset3 + 13
    DYNgrailParams.DDDYNbraceType.pos.x    = LOCoffset3 + 13
    DYNgrailParams.LBDYNbraceMat.pos.x     = LOCoffset3 + 13
    DYNgrailParams.DDDYNbraceMat.pos.x     = LOCoffset3 + 13
    DYNgrailParams.LBDYNbraceDepth.pos.x   = LOCoffset3 + 13
    DYNgrailParams.SPDYNbraceDepth.pos.x   = LOCoffset3 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNbraceHeight.pos.x  = LOCoffset3 + 13
    DYNgrailParams.SPDYNbraceHeight.pos.x  = LOCoffset3 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNbraceGap.pos.x     = LOCoffset3 + 13
    DYNgrailParams.SPDYNbraceGap.pos.x     = LOCoffset3 + (DYNiniExplorerWidth - 39)

    --- Rail Params
    DYNgrailParams.CKDYNrailLeftOn.pos.x   = LOCoffset4 + 13
    DYNgrailParams.CKDYNrailRightOn.pos.x  = LOCoffset4 + (DYNiniExplorerWidth - 106)
    DYNgrailParams.LBDYNrailType.pos.x     = LOCoffset4 + 13
    DYNgrailParams.DDDYNrailType.pos.x     = LOCoffset4 + 13
    DYNgrailParams.LBDYNrailMat.pos.x      = LOCoffset4 + 13
    DYNgrailParams.DDDYNrailMat.pos.x      = LOCoffset4 + 13
    DYNgrailParams.LBDYNrailVertical.pos.x = LOCoffset4 + 13
    DYNgrailParams.SPDYNrailVertical.pos.x = LOCoffset4 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNrailWidth.pos.x    = LOCoffset4 + 13
    DYNgrailParams.SPDYNrailWidth.pos.x    = LOCoffset4 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNrailHeight.pos.x   = LOCoffset4 + 13
    DYNgrailParams.SPDYNrailHeight.pos.x   = LOCoffset4 + (DYNiniExplorerWidth - 39)
    DYNgrailParams.LBDYNgUVrepeat.pos.x    = LOCoffset4 + 13
    DYNgrailParams.SPDYNgUVrepeat.pos.x    = LOCoffset4 + (DYNiniExplorerWidth - 39)
  )

  fn DYNFUNsaveRosfile FUNrollout FUNobjMod =
  (
    local LOCtempFile = DYNFUNgetSaveFileName "ROS" FUNrollout.LOCrosPath FUNrollout.LOCresourceKitMode false
    FUNrollout.LOCresourceKitMode = DYNfileSelectorKitMode

    if LOCtempFile != undefined then
    (
      local LOCcurrentFileStream = try (createFile LOCtempFile) catch ()
      if LOCcurrentFileStream != undefined then
      (
        format "5000,1=%,2=%,3=%,6=%,7=%,10=%\n" (FUNrollout.SPDYNgHeight.value as string) (FUNrollout.SPDYNgWidthL.value as string) (FUNrollout.SPDYNgWidthR.value as string) (FUNrollout.SPDYNgOffsetZ.value as string) (FUNrollout.SPDYNgOffsetX.value as string) "*" to:LOCcurrentFileStream
        format "5001,1=%,2=%,3=%,4=%,5=%,6=%,7=%,8=%,9=%,10=%\n" (if FUNrollout.CKDYNpostOn.checked then "1" else "0") (if FUNrollout.CBDYNpostFlip.checked then "1" else "0") ((FUNrollout.DDDYNpostType.selection - 1) as string) (if FUNrollout.CBDYNpostCapT.checked then "1" else "0") (FUNrollout.SPDYNspacing.value as string) (FUNrollout.SPDYNpostWidth.value as string) (FUNrollout.SPDYNpostDepth.value as string) (FUNrollout.SPDYNgroundDepth.value as string) (if FUNrollout.CBDYNpostCapB.checked then "1" else "0") (FUNrollout.DDDYNpostMat.selection as string) to:LOCcurrentFileStream
        format "5002,1=%,3=%,5=%,6=%,7=%,10=%\n" (if FUNrollout.CKDYNbraceOn.checked then "1" else "0") ((FUNrollout.DDDYNbraceType.selection - 1) as string) (FUNrollout.SPDYNbraceGap.value as string) (FUNrollout.SPDYNbraceHeight.value as string) (FUNrollout.SPDYNbraceDepth.value as string) (FUNrollout.DDDYNbraceMat.selection as string) to:LOCcurrentFileStream
        format "5003,1=%,2=%,3=%,5=%,6=%,7=%,9=%,10=%\n" (if FUNrollout.CKDYNrailLeftOn.checked then "1" else "0") (if FUNrollout.CKDYNrailRightOn.checked then "1" else "0") ((FUNrollout.DDDYNrailType.selection - 1) as string) (FUNrollout.SPDYNrailVertical.value as string) (FUNrollout.SPDYNrailHeight.value as string) (FUNrollout.SPDYNrailWidth.value as string) (FUNrollout.SPDYNgUVrepeat.value as string) (FUNrollout.DDDYNrailMat.selection as string) to:LOCcurrentFileStream
        close LOCcurrentFileStream

        setAppData FUNrollout.LOCobj 424 LOCtempFile

        --- Update AppData for objects containing instances of this modifier
        local LOCinstances = DYNFUNnodesWithInstancesOfModifier FUNobjMod
        for i = 1 to LOCinstances.count do (setAppData LOCinstances[i] 424 LOCtempFile)

        FUNrollout.LOCrosStyle  = LOCtempFile
        FUNrollout.LOCrosPath   = LOCtempFile
        DYNGRailParams.DYNFUNGRailParams FUNrollout.LOCobj DYNGRailParams FUNrollout.LOCobjMod
      )
      else
      (
        messagebox DYNuiResourcesErrorsWarnings[16] title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  fn DYNFUNgRailParamsCallback =
  (
    --- Get : #(node, modifier)
    local LOCnotifyParam = callbacks.notificationParam()

    if try (DYNgRailParams.LOCobj == LOCnotifyParam[1]) catch (false) then
    (
      for i in DYNgRailParams.controls do i.enabled = false
    )
  )

  fn DYNFUNGRailParams FUNobj FUNrollout FUNobjMod =
  (
    --- Get Object References
    FUNrollout.LOCobj = FUNobj
    FUNrollout.PKDYNparent.text = try (FUNobj.parent.name) catch (DYNuiResourcesButtons[15])

    FUNrollout.LOCrosStyle           = getAppData FUNobj 424; if FUNrollout.LOCrosStyle == undefined then FUNrollout.LOCrosStyle = ""
    FUNrollout.LOCrosPath            = if FUNrollout.LOCrosStyle == "" then rootNode.DYNrootNodeStore.rosPath else FUNrollout.LOCrosStyle

    FUNrollout.LOCobjMod = FUNobjMod

    if FUNobjMod != undefined then
    (

      --- Load General Parameters
      FUNrollout.CBDYNlock.checked       = if FUNobjMod.widthLeft == FUNobjMod.widthRight then true else false
      FUNrollout.SPDYNgWidthL.value      = FUNobjMod.widthLeft
      FUNrollout.SPDYNgWidthR.value      = FUNobjMod.widthRight
      FUNrollout.SPDYNgHeight.value      = FUNobjMod.height
      FUNrollout.SPDYNgOffsetX.value     = FUNobjMod.offsetx
      FUNrollout.SPDYNgOffsetZ.value     = FUNobjMod.offsetz

      --- Load Post Parameters
      DYNFUNpostEnable FUNobjMod.postOn FUNobj FUNrollout
      FUNrollout.CKDYNpostOn.checked     = FUNobjMod.postOn
      FUNrollout.CBDYNpostFlip.checked   = FUNobjMod.postFlip
      FUNrollout.CBDYNpostCapT.checked   = FUNobjMod.postCapTop
      FUNrollout.CBDYNpostCapB.checked   = FUNobjMod.postCapBottom
      FUNrollout.SPDYNspacing.value      = FUNobjMod.spacing
      FUNrollout.SPDYNpostWidth.value    = FUNobjMod.postWidth
      FUNrollout.SPDYNpostDepth.value    = FUNobjMod.postDepth
      FUNrollout.SPDYNgroundDepth.value  = FUNobjMod.groundDepth
      FUNrollout.DDDYNpostType.selection = FUNobjMod.postType + 1

      --- Load Brace Parameters
      DYNFUNbraceEnable FUNobjMod.braceOn FUNobj FUNrollout
      FUNrollout.CKDYNbraceOn.checked    = FUNobjMod.braceOn
      FUNrollout.SPDYNbraceDepth.value   = FUNobjMod.braceDepth
      FUNrollout.SPDYNbraceHeight.value  = FUNobjMod.braceHeight
      FUNrollout.SPDYNbraceGap.value     = FUNobjMod.braceGap
      FUNrollout.DDDYNbraceType.selection = FUNobjMod.braceType + 1

      --- Load Rail Parameters
      DYNFUNrailEnable FUNobjMod.railLeftOn FUNobjMod.railRightOn FUNobj FUNrollout
      FUNrollout.CKDYNrailLeftOn.checked  = FUNobjMod.railLeftOn
      FUNrollout.CKDYNrailRightOn.checked = FUNobjMod.railRightOn
      FUNrollout.SPDYNrailHeight.value    = (FUNobjMod.railheight - FUNobjMod.railVertical) / 2
      FUNrollout.SPDYNrailWidth.value     = FUNobjMod.railwidth
      FUNrollout.SPDYNrailVertical.value  = FUNobjMod.railVertical
      FUNrollout.DDDYNrailType.selection  = FUNobjMod.railType + 1
      FUNrollout.SPDYNgUVrepeat.value    = FUNobjMod.uvrepeat

      FUNrollout.LBDYNfile.text = FileNameFromPath FUNrollout.LOCrosStyle

      --- Sort out materials
      if classOf FUNobj.material == Multimaterial then
      (
        local LOCmatArray = DYNFUNgetMatChannelNames FUNobj.material true true DYNINImatIDlimit
        FUNrollout.DDDYNpostMat.items  = LOCmatArray
        FUNrollout.DDDYNbraceMat.items = LOCmatArray
        FUNrollout.DDDYNrailMat.items  = LOCmatArray
        FUNrollout.DDDYNpostMat.selection  = if FUNobjMod.postMatID  <= FUNrollout.DDDYNpostMat.items.count  then (FUNobjMod.postMatID)  else (FUNrollout.DDDYNpostMat.items.count)
        FUNrollout.DDDYNbraceMat.selection = if FUNobjMod.braceMatID <= FUNrollout.DDDYNbraceMat.items.count then (FUNobjMod.braceMatID) else (FUNrollout.DDDYNbraceMat.items.count)
        FUNrollout.DDDYNrailMat.selection  = if FUNobjMod.railMatID  <= FUNrollout.DDDYNrailMat.items.count  then (FUNobjMod.railMatID)  else (FUNrollout.DDDYNrailMat.items.count)
        FUNobjMod.postMatID  = FUNrollout.DDDYNpostMat.selection
        FUNobjMod.braceMatID = FUNrollout.DDDYNbraceMat.selection
        FUNobjMod.railMatID  = FUNrollout.DDDYNrailMat.selection
      )
      else
      (
        FUNrollout.DDDYNpostMat.items  = #()
        FUNrollout.DDDYNbraceMat.items = #()
        FUNrollout.DDDYNrailMat.items  = #()
      )
      if FUNrollout == DYNgRailParams then
      (
        DYNFUNgatherNodesWithModInstances FUNrollout FUNobjMod
      )
    )
    else
    (
      for i in FUNrollout.controls do i.enabled = false
      if FUNrollout == DYNgRailParams then
      (
        FUNrollout.CBDYNlinked.checked     = false
        FUNrollout.CBDYNlinked.text        = DYNuiResourcesButtons[37]
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dotNetControl dnTabCtrl "System.Windows.Forms.TabControl" height:23  width:(DYNiniExplorerWidth - 21) pos:[4,12]

  groupBox GBDYNtab             pos:[4,28]     width:(DYNiniExplorerWidth - 21) height:235
  label LBtabDescription        pos:[13,39]    width:(DYNiniExplorerWidth - 39) align:#center

  ---  General Parameters
  groupbox GBDYNparent          pos:[2013,57]  width:(DYNiniExplorerWidth - 39) height:44
  pickbutton PKDYNparent        pos:[2018,74]  align:#center width:(DYNiniExplorerWidth - 49) filter:DYNFUNshapeFilter
  label   LBDYNgWidthL          pos:[2013,109] align:#left width:105
  spinner SPDYNgWidthL          pos:[2061,107] fieldWidth:40 type:#worldunits scale:0.01
  label   LBDYNgWidthR          pos:[2013,130] align:#left width:105
  spinner SPDYNgWidthR          pos:[2119,129] fieldWidth:40 type:#worldunits scale:0.01
  label   LBDYNgHeight          pos:[2013,162] align:#left width:105
  spinner SPDYNgHeight          pos:[2119,160] fieldWidth:56 type:#worldunits scale:0.01
  label   LBDYNgOffsetX         pos:[2013,191] align:#left width:105
  spinner SPDYNgOffsetX         pos:[2119,189] fieldWidth:56 type:#worldunits scale:0.01 range:[-1000.0,1000.0,0]
  label   LBDYNgOffsetZ         pos:[2013,212] align:#left width:105
  spinner SPDYNgOffsetZ         pos:[2119,210] fieldWidth:56 type:#worldunits scale:0.01 range:[-1000.0,1000.0,0]
  checkbutton CBDYNlock         pos:[(DYNINIexplorerWidth - 39),118]  width:16 height:18 iconName:"Common/Lock" iconSize:[16,16] checked:true highlightColor:DYNINIhighlightColor
  button BUDYNmirror            pos:[2018,233] align:#center width:(DYNiniExplorerWidth - 39)

  ---  Post Parameters
  checkbox CKDYNposton          pos:[2013,58]  align:#left width:45
  label   LBDYNpostType         pos:[2013,79]  align:#left width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNpostType    pos:[2013,94]  align:#left width:(DYNiniExplorerWidth - 39)
  checkbutton CBDYNpostFlip     pos:[2096,55]  align:#left width:75 height:20 pos:[119,DYNGRailParams.DDDYNpostType.pos.y] highlightColor:DYNINIhighlightColor
  checkbutton CBDYNpostCapT     pos:[2013,230] align:#left width:75 height:20 pos:[137,DYNGRailParams.DDDYNpostType.pos.y] highlightColor:DYNINIhighlightColor
  checkbutton CBDYNpostCapB     pos:[2096,230] align:#left width:75 height:20 pos:[155,DYNGRailParams.DDDYNpostType.pos.y] highlightColor:DYNINIhighlightColor
  label LBDYNpostWidth          pos:[2013,121] align:#left width:45
  spinner SPDYNpostWidth "X"    pos:[2060,121] fieldWidth:45 type:#worldunits scale:0.01
  spinner SPDYNpostDepth "Y"    pos:[2113,121] fieldWidth:45 type:#worldunits scale:0.01
  label LBDYNspacing            pos:[2013,144] align:#left width:105
  spinner SPDYNspacing          pos:[2119,142] fieldWidth:60 type:#worldunits scale:0.01 range:[0.5,1000.0,3.0]
  label LBDYNgroundDepth        pos:[2013,165] align:#left width:105
  spinner SPDYNgroundDepth      pos:[2119,163] fieldWidth:60 type:#worldunits scale:0.01
  label   LBDYNpostMat          pos:[2013,188] align:#left width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNpostMat     pos:[2013,203] align:#left width:(DYNiniExplorerWidth - 39)

  ---  Brace Parameters
  checkbox CKDYNbraceOn         pos:[2013,58]  align:#left  width:45
  label   LBDYNbraceType        pos:[2013,79]  align:#left  width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNbraceType   pos:[2013,94]  align:#left  width:(DYNiniExplorerWidth - 39)
  label   LBDYNbraceDepth       pos:[2013,123] align:#left width:105
  spinner SPDYNbraceDepth       pos:[2119,121] fieldWidth:60 type:#worldunits scale:0.01
  label   LBDYNbraceHeight      pos:[2013,144] align:#left width:105
  spinner SPDYNbraceHeight      pos:[2119,142] fieldWidth:60 type:#worldunits scale:0.01
  label   LBDYNbraceGap         pos:[2013,165] align:#left width:105
  spinner SPDYNbraceGap         pos:[2119,163] fieldWidth:60 type:#worldunits scale:0.01
  label   LBDYNbraceMat         pos:[2013,188] align:#left width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNbraceMat    pos:[2013,203] align:#left width:(DYNiniExplorerWidth - 39)

  --- Rail Parameters
  checkbox CKDYNrailLeftOn      pos:[2013,58]  align:#left width:75
  checkbox CKDYNrailRightOn     pos:[2092,58]  align:#left width:75
  label   LBDYNrailType         pos:[2013,79]  align:#left width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNrailType    pos:[2013,94]  align:#left width:(DYNiniExplorerWidth - 39)
  label    LBDYNrailVertical    pos:[2013,123] align:#left width:105
  spinner  SPDYNrailVertical    pos:[2119,121] fieldWidth:60 type:#worldunits
  label    LBDYNrailWidth       pos:[2013,144] align:#left width:105
  spinner  SPDYNrailWidth       pos:[2119,142] fieldWidth:60 type:#worldunits
  label    LBDYNrailHeight      pos:[2013,165] align:#left width:105
  spinner  SPDYNrailHeight      pos:[2119,163] fieldWidth:60 type:#worldunits range:[-1000,1000,0]
  label   LBDYNrailMat          pos:[2013,188] align:#left width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNrailMat     pos:[2013,203] align:#left width:(DYNiniExplorerWidth - 39)
  label   LBDYNgUVrepeat        pos:[2013,232] align:#left width:105
  spinner SPDYNgUVrepeat        pos:[2119,230] fieldWidth:60 type:#worldunits scale:0.1

  groupBox GBDYNstyles          pos:[4,268] align:#left width:(DYNiniExplorerWidth - 21) height:78
  button BUDYNfile              pos:[(-14 + (DYNiniExplorerWidth * 0.197)),290] align:#center iconName:"CivilView/Open" width:28 height:28 tooltip:DYNuiResourcesTooltips[5]
  button BUDYNsave              pos:[(-14 + (DYNiniExplorerWidth * 0.465)),290] align:#center iconName:"Common/Save" width:28 height:28 tooltip:DYNuiResourcesTooltips[6]
  button BUDYNreset             pos:[(-14 + (DYNiniExplorerWidth * 0.732)),290] align:#center iconName:"CivilView/Reset" width:28 height:28 tooltip:DYNuiResourcesTooltips[14]
  label  LBDYNfile              pos:[25,325]  align:#center width:(DYNiniExplorerWidth - 60)

  groupbox GBDYNgroup06         pos:[4,351]   width:(DYNiniExplorerWidth - 21) height:72
  checkbutton CBDYNlinked       pos:[13,370]  width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor
  pickbutton PKDYNlink          pos:[13,396]  width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor filter:DYNFUNdynGRailFilter

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNGRailParams open do
  (
    DYNGRailParams.title  = DYNuiRolloutNames[51]

    --- Set Up TAB Control
    dntabctrl.tabpages.add DYNuiResourcesLabels[436]
    dntabctrl.tabpages.add DYNuiResourcesLabels[423]
    dntabctrl.tabpages.add DYNuiResourcesLabels[424]
    dntabctrl.tabpages.add DYNuiResourcesLabels[425]

    --- Add Callback To Detect If Spline Modifier Is Deleted While This Panel Is Open
    /* If this is not detected, modifying params in this panel can cause script error after modifier has been deleted */
    callbacks.removescripts id:#DYNgRailParams
    callbacks.addscript #postModifierDeleted "DYNgRailParams.DYNFUNgRailParamsCallback()" id:#DYNgRailParams

    CBDYNpostFlip.text    = DYNuiResourcesButtons[102]
    CBDYNpostCapT.text    = DYNuiResourcesButtons[103]
    CBDYNpostCapB.text    = DYNuiResourcesButtons[104]

    DDDYNpostType.items   = #(DYNuiResourcesLabels[426], DYNuiResourcesLabels[427])
    DDDYNbraceType.items  = #(DYNuiResourcesLabels[428], DYNuiResourcesLabels[429])
    DDDYNrailType.items   = #(DYNuiResourcesLabels[430], DYNuiResourcesLabels[431], DYNuiResourcesLabels[432], DYNuiResourcesLabels[433], DYNuiResourcesLabels[434], DYNuiResourcesLabels[435])

    --- General Params
    GBDYNstyles.text      = DYNuiResourcesCvExplorer[18]
    GBDYNparent.text      = DYNuiResourcesGroups[14]
    LBDYNgWidthL.text     = DYNuiResourcesLabels[404]
    LBDYNgWidthR.text     = DYNuiResourcesLabels[405]
    LBDYNgHeight.text     = DYNuiResourcesLabels[30]
    LBDYNgOffsetX.text    = DYNuiResourcesLabels[1]
    LBDYNgOffsetZ.text    = DYNuiResourcesLabels[2]
    BUDYNmirror.text      = DYNuiResourcesButtons[100]
    --- Post Params
    CKDYNpostOn.text      = DYNuiResourcesLabels[22]
    LBDYNspacing.text     = DYNuiResourcesLabels[406]
    LBDYNpostWidth.text   = DYNuiResourcesLabels[407]
    LBDYNgroundDepth.text = DYNuiResourcesLabels[201]
    LBDYNpostType.text    = DYNuiResourcesLabels[408]
    LBDYNpostMat.text     = DYNuiResourcesLabels[409]

    --- Brace Params
    CKDYNbraceOn.text     = DYNuiResourcesLabels[22]
    LBDYNbraceDepth.text  = DYNuiResourcesLabels[410]
    LBDYNbraceHeight.text = DYNuiResourcesLabels[411]
    LBDYNbraceGap.text    = DYNuiResourcesLabels[412]
    LBDYNbraceType.text   = DYNuiResourcesLabels[413]
    LBDYNbraceMat.text    = DYNuiResourcesLabels[414]

    --- Rail Params
    CKDYNrailLeftOn.text  = DYNuiResourcesLabels[415]
    CKDYNrailRightOn.text = DYNuiResourcesLabels[416]
    LBDYNrailVertical.text= DYNuiResourcesLabels[417]
    LBDYNrailWidth.text   = DYNuiResourcesLabels[418]
    LBDYNrailHeight.text  = DYNuiResourcesLabels[419]
    LBDYNrailMat.text     = DYNuiResourcesLabels[420]
    LBDYNrailType.text    = DYNuiResourcesLabels[421]
    LBDYNgUVrepeat.text   = DYNuiResourcesLabels[422]

    LOCrosPath            = DYNcountryPath + DYNlocalRosPath
    LBDYNfile.text        = FileNameFromPath LOCrosStyle

    GBDYNgroup06.text     = DYNuiResourcesGroups[1]
    PKDYNlink.text        = DYNuiResourcesButtons[24]

    DYNFUNchangeGrailUItab 1
    SPDYNgOffsetZ.indeterminate = true
    SPDYNgOffsetZ.indeterminate = false
  )

  on DYNGRailParams close do
  (
    callbacks.removescripts id:#DYNgRailParams
    LOCobj = undefined
  )

  on dnTabCtrl mouseUp arg do
  (
    DYNFUNchangeGrailUItab (dnTabCtrl.selectedTab.TabIndex + 1)
  )

  on PKDYNparent picked LOCnewParent do
  (
    --- "if open" required to ensure that pickbutton is not still "picking" after panel closes
    if DYNGRailParams.open do
    (
      undo off
      (
        if superClassOf LOCnewParent == shape then
        (
          DYNFUNloadVSPnodeCallBacks false
          (
            local LOColdObj = LOCobj
            local LOCobjArray = DYNFUNcreateRails #(LOCnewParent) LOCrosStyle (DYNFUNgetLocalTime()) false sceneMaterials #() (CVGetMod LOColdObj Civil_View_Guard_Rail) true
            if LOCobjArray.count > 0 then LOCobj = LOCobjArray[1]
            local LOCsuccessSwitch = DYNFUNapplyModifierInstance Civil_View_Guard_Rail LOCobj LOColdObj true
            if LOCsuccessSwitch and isValidNode LOColdObj then delete LOColdObj
          )
          DYNFUNloadVSPnodeCallBacks true
          DYNFUNnodeCreatedCallback()
          if isValidNode LOCobj then select LOCobj else clearSelection()
        )
      )
    )
  )

  on CBDYNlock changed arg do
  (
    if arg then
    (
      SPDYNgWidthR.value = LOCobjMod.widthRight = LOCobjMod.widthLeft
    )
  )

  on SPDYNgWidthL       changed arg do
  (
    LOCobjMod.widthLeft    = arg
    if CBDYNlock.checked then (SPDYNgWidthR.value = LOCobjMod.widthRight = arg)
  )
  on SPDYNgWidthR       changed arg do
  (
    LOCobjMod.widthRight   = arg
    if CBDYNlock.checked then (SPDYNgWidthL.value = LOCobjMod.widthLeft = arg)
  )
  on SPDYNgOffsetX      changed arg do (LOCobjMod.offsetx       = arg)

  on BUDYNmirror        pressed do
  (
    ---Mirror Offsets
    local LOCsaveRailOffsets = [LOCobjMod.widthLeft,LOCobjMod.widthRight]
    if LOCobjMod.offsetx != 0.0 then (SPDYNgOffsetX.value = LOCobjMod.offsetx = -LOCobjMod.offsetx)
    SPDYNgWidthL.value  = LOCobjMod.widthLeft  = LOCsaveRailOffsets.y
    SPDYNgWidthR.value  = LOCobjMod.widthRight = LOCsaveRailOffsets.x

    --- Mirror Rail Activation
    local LOCsaveRailEnabled = #(LOCobjMod.railLeftOn, LOCobjMod.railRightOn)
    CKDYNrailLeftOn.checked  = LOCobjMod.railLeftOn  = LOCsaveRailEnabled[2]
    CKDYNrailRightOn.checked = LOCobjMod.railRightOn = LOCsaveRailEnabled[1]
    DYNFUNrailEnable LOCobjMod.railLeftOn LOCobjMod.railRightOn LOCobj DYNgRailParams
  )

  on SPDYNgHeight       changed arg do (LOCobjMod.height        = arg)
  on SPDYNgOffsetZ      changed arg do (LOCobjMod.offsetz       = arg)

  on CKDYNposton        changed arg do (LOCobjMod.postOn        = arg; DYNFUNpostEnable arg LOCobj DYNgRailParams)
  on CBDYNpostflip      changed arg do (LOCobjMod.postFlip      = arg)
  on CBDYNpostCapT      changed arg do (LOCobjMod.postCapTop    = arg)
  on CBDYNpostCapB      changed arg do (LOCobjMod.postCapBottom = arg)
  on SPDYNspacing       changed arg do (LOCobjMod.spacing       = arg)
  on SPDYNpostWidth     changed arg do (LOCobjMod.postWidth     = arg)
  on SPDYNpostDepth     changed arg do (LOCobjMod.postDepth     = arg)
  on SPDYNgroundDepth   changed arg do (LOCobjMod.groundDepth   = arg)
  on DDDYNpostType     selected arg do (LOCobjMod.postType      = arg - 1)
  on DDDYNpostMat      selected arg do (LOCobjMod.postMatID     = arg)

  on CKDYNbraceOn       changed arg do (LOCobjMod.braceOn       = arg; DYNFUNbraceEnable arg LOCobj DYNgRailParams)
  on SPDYNbraceDepth    changed arg do (LOCobjMod.braceDepth    = arg)
  on SPDYNbraceHeight   changed arg do (LOCobjMod.braceHeight   = arg)
  on SPDYNbraceGap      changed arg do (LOCobjMod.braceGap      = arg)
  on DDDYNbraceType    selected arg do (LOCobjMod.braceType     = arg - 1)
  on DDDYNbraceMat     selected arg do (LOCobjMod.braceMatID    = arg)

  on CKDYNrailLeftOn    changed arg do (LOCobjMod.railLeftOn    = arg; DYNFUNrailEnable arg CKDYNrailRightOn.checked LOCobj DYNgRailParams)
  on CKDYNrailRightOn   changed arg do (LOCobjMod.railRightOn   = arg; DYNFUNrailEnable CKDYNrailLeftOn.checked arg LOCobj DYNgRailParams)
  on SPDYNrailHeight    changed arg do (LOCobjMod.railheight    = (arg * 2) + LOCobjMod.railVertical)
  on SPDYNrailWidth     changed arg do (LOCobjMod.railwidth     = arg)
  on SPDYNrailVertical  changed arg do (LOCobjMod.railVertical  = arg; LOCobjMod.railheight = ((SPDYNrailHeight.value * 2) + arg))
  on DDDYNrailType     selected arg do (LOCobjMod.railType      = arg - 1)
  on DDDYNrailMat      selected arg do (LOCobjMod.railMatID     = arg)
  on SPDYNgUVrepeat     changed arg do (LOCobjMod.uvrepeat      = arg)

  on BUDYNsave pressed do
  (
    DYNFUNsaveROSfile DYNgRailParams LOCobjMod
    if isValidNode LOCobj then select LOCobj else clearSelection()
  )
  on BUDYNfile pressed do
  (
    --- Ask user to select a OPS Style from the filesystem
    local LOCtempFile = LOCrosStyle

    LOCtempFile = DYNFUNgetOpenFileName "ROS" LOCrosPath LOCresourceKitMode false
    LOCresourceKitMode = DYNfileSelectorKitMode

    if LOCtempFile != undefined then
    (
      if doesFileExist LOCtempFile and LOCtempFile != "" then
      (
        local LOCrosStyleContents = DYNFUNparsePARAMfile LOCtempFile "5000"
        if LOCrosStyleContents.count >= 1 then
        (
          DYNFUNmodifyRail LOCobjMod LOCrosStyleContents[1]
          DYNFUNgenObjAppData LOCobj "12" "0" LOCtempFile (DYNFUNgetLocalTime()) "" "" ""

          --- Update AppData for objects containing instances of this modifier
          local LOCinstances = DYNFUNnodesWithInstancesOfModifier LOCobjMod
          for i = 1 to LOCinstances.count do (DYNFUNgenObjAppData LOCinstances[i] "12" "0" LOCtempFile (DYNFUNgetLocalTime()) "" "" "")

          DYNFUNGRailParams LOCobj DYNGRailParams LOCobjMod
          LOCrosPath = LOCrosStyle
        )
      )
    )
    if isValidNode LOCobj then select LOCobj else clearSelection()
  )

  on BUDYNreset pressed do
  (
    if doesFileExist LOCrosStyle then
    (
      if (queryBox (DYNuiResourcesQueries[8]) beep:false) then
      (
        local LOCrosStyleContents = DYNFUNparsePARAMfile LOCrosStyle "5000"
        if LOCrosStyleContents.count >= 1 then
        (
          DYNFUNmodifyRail LOCobjMod LOCrosStyleContents[1]
          DYNFUNgenObjAppData LOCobj "12" "0" LOCrosStyle (DYNFUNgetLocalTime()) "" "" ""

          --- Update AppData for objects containing instances of this modifier
          local LOCinstances = DYNFUNnodesWithInstancesOfModifier LOCobjMod
          for i = 1 to LOCinstances.count do (DYNFUNgenObjAppData LOCinstances[i] "12" "0" LOCrosStyle (DYNFUNgetLocalTime()) "" "" "")

          DYNFUNGRailParams LOCobj DYNGRailParams LOCobjMod
        )
      )
    )
    else
    (
      if (queryBox (DYNuiResourcesQueries[9]) beep:false) then
      (
        LOCrosStyle = ""
        DYNFUNmodifyRail LOCobjMod #()
        DYNFUNgenObjAppData LOCobj "12" "0" LOCrosStyle (DYNFUNgetLocalTime()) "" "" ""

        --- Update AppData for objects containing instances of this modifier
        local LOCinstances = DYNFUNnodesWithInstancesOfModifier LOCobjMod
        for i = 1 to LOCinstances.count do (DYNFUNgenObjAppData LOCobj "12" "0" LOCrosStyle (DYNFUNgetLocalTime()) "" "" "")

        DYNFUNGRailParams LOCobj DYNGRailParams LOCobjMod
        LOCrosPath = DYNcountryPath + DYNlocalRosPath
      )
    )
    if isValidNode LOCobj then select LOCobj else clearSelection()
  )

  on CBDYNlinked changed arg do
  (
    if arg == false and (InstanceMgr.CanMakeModifiersUnique LOCobj (CVGetMod LOCobj Civil_View_Guard_Rail)) then
    (
      if (queryBox (DYNuiResourcesQueries[10]) title:DYNuiResourcesTitlebars[2]) then
      (
        InstanceMgr.makeModifiersUnique LOCobj (CVGetMod LOCobj Civil_View_Guard_Rail) #prompt
      )
      else CBDYNlinked.checked = true
    )
    DYNFUNgRailParams LOCobj DYNgRailParams (CVGetMod LOCobj Civil_View_Guard_Rail)
  )

  on PKDYNlink picked arg do
  (
    DYNFUNapplyModifierInstance Civil_View_Guard_Rail LOCobj arg true
    DYNFUNgRailParams LOCobj DYNgRailParams (CVGetMod LOCobj Civil_View_Guard_Rail)
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB0puha5b2YK3IuK25EddfuF55iaNHUxxxQ
-- Br4Qjv/QDhgV4+JGRKfoKe3RjEFd8Gos54A9UnUbf72u/Ja94B+CAshB/AqCiEeM
-- 1ESu0jJLGBw4D03BH0gKI0Ul+GBnRt5/woE9c1gDlgcYzONzB39RwTiIkLO+gxlc
-- gpIJS0YXWDG0ozSmZOvKKrpX4OxaIk01Si7kN4D8BEvVnMkFsiHZ2P/W6fLlMoXs
-- NfJhjx1N91Zg8VWaR5Xkq6mEKWm+ZFA+W/t7v4tCeHnmLHM+dtZWF4zr9Ni7H6FV
-- wm8/g9+6ny7KY1XgONPGxIl1i97PH98XsbPluDV8F2A+fSQQVbht
-- -----END-SIGNATURE-----